using System;
using System.Data;
using System.Windows.Forms;
using TABLE = gov.va.med.vbecs.Common.VbecsTables.CannedComment;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmMaintainSpecimen
	/// </summary>
	public class FrmMaintainSpecimen : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		/// <summary>
		/// Current working specimen
		/// </summary>
		private BOL.Specimen _specimen;

		/// <summary>
		/// Current working order
		/// </summary>
		private BOL.PatientOrder _order;

		/// <summary>
		/// List of available canned comments
		/// </summary>
		private DataTable _dtCannedComment;

		private System.Collections.ArrayList _users;
		/// <summary>
		/// Are the controls being populated with information through code (non-user changes)
		/// </summary>
		private bool _isLoading;

		/// <summary>
		/// Current date value based on the division time zone
		/// </summary>
		private System.DateTime _currentDate;
		#endregion

		#region Form Controls

		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.GroupBox grpSpecimen;
		private System.Windows.Forms.TextBox txtPhlebotomist;
		private System.Windows.Forms.Label lblPhlebotomist;
		private System.Windows.Forms.Label lblCollectionDate;
		private System.Windows.Forms.DateTimePicker dtpExpirationDate;
		private System.Windows.Forms.Label lblExpirationDate;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.DateTimePicker dtpCollectionDate;
		private System.Windows.Forms.TextBox txtDetails;
		private System.Windows.Forms.Label lblDetails;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbComment;
		private System.Windows.Forms.Label lblComment;
		private System.Windows.Forms.Button btnSelectSpecimen;
		private System.Windows.Forms.Label lblSpecimenNumber;
		private System.Windows.Forms.DateTimePicker dtpReceivedDate;
		private System.Windows.Forms.Label lblReceivedDate;
		private System.Windows.Forms.PictureBox pictureBox2;
        private gov.va.med.vbecs.GUI.controls.BarcodeTextbox txtSpecimenNumber;
		private System.Windows.Forms.ColumnHeader colOrder;
		private System.Windows.Forms.GroupBox grpComments;
		private System.Windows.Forms.Label lblProcessingTech;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbProcessingTech;
		private System.Windows.Forms.RadioButton rdoAcceptable;
		private System.Windows.Forms.RadioButton rdoUnacceptable;
		private System.Windows.Forms.GroupBox grpAssociatedOrders;
		private System.Windows.Forms.ListView lvAssociatedOrders;
		private System.Windows.Forms.ColumnHeader colWanted;
		private System.Windows.Forms.ColumnHeader colStatus;
		private System.Windows.Forms.GroupBox grpSplit;
        private controls.PatientDisplayPanel patientDisplayPanel1;
		private System.ComponentModel.IContainer components = null;
		
		#endregion

		#region Constructors/Dispose


		/// <summary>
		/// FrmMaintainSpecimen
		/// </summary>
		public FrmMaintainSpecimen()
		{
			InitializeComponent();
			this.SetComponentProperties();

			this._specimen = new BOL.Specimen();
			this._specimen.SetInitialBrokenRules(this.Name, "NewSpecimen");

			this.SetControlData(false);	
		}

		/// <summary>
		/// FrmMaintainSpecimen
		/// </summary>
		public FrmMaintainSpecimen(BOL.Specimen specimen, BOL.PatientOrder order)
		{
			InitializeComponent();
			this.SetComponentProperties();

			//this._specimen = new BOL.Specimen();
			this._order = order;
			this.patientDisplayPanel1.Patient = _order.Patient;
			//
			this._specimen = new BOL.Specimen(specimen.SpecimenUid);
			this._specimen.Patient = this._order.Patient;
			this._specimen.IsAssociatedWithPendingOrder = true;
			this._specimen.MaintainableSpecimenIndicator = true;
			this.btnSelectSpecimen.Enabled = false;
			this.txtSpecimenNumber.ReadOnly = true;
			//
			if (this._specimen.IsNew)
			{
				this._specimen.SetInitialBrokenRules(this.Name, "NewSpecimen");
			}
			else
			{
				this._specimen.SetInitialBrokenRules(this.Name, "ExistingSpecimen");
			}
			_specimen.Valid += new System.EventHandler(this.CheckValid);
			_specimen.Invalid += new System.EventHandler(this.CheckValid);
			_specimen.IsDirtyChanged += new System.EventHandler(this.CheckValid);
			//
			//Reset broken rules!
			this._specimen.SpecimenUid = specimen.SpecimenUid;
			this._specimen.SpecimenCollectionDate = specimen.SpecimenCollectionDate;
			this._specimen.UnacceptableSpecimenIndicator = specimen.UnacceptableSpecimenIndicator;
			this._specimen.SpecimenExpirationDate = specimen.SpecimenExpirationDate;
			this._specimen.Phlebotomist = specimen.Phlebotomist;
			this._specimen.SpecimenAccessionNumber = specimen.SpecimenAccessionNumber;
			CheckValid(this, System.EventArgs.Empty);
			//
			this.SetControlData(true);
			this.SetControlState(true);
		}



		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmMaintainSpecimen));
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnCancel = new System.Windows.Forms.Button();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.grpSpecimen = new System.Windows.Forms.GroupBox();
            this.grpSplit = new System.Windows.Forms.GroupBox();
            this.rdoAcceptable = new System.Windows.Forms.RadioButton();
            this.cmbProcessingTech = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblProcessingTech = new System.Windows.Forms.Label();
            this.txtSpecimenNumber = new gov.va.med.vbecs.GUI.controls.BarcodeTextbox(this.components);
            this.pictureBox2 = new System.Windows.Forms.PictureBox();
            this.dtpReceivedDate = new System.Windows.Forms.DateTimePicker();
            this.lblReceivedDate = new System.Windows.Forms.Label();
            this.btnSelectSpecimen = new System.Windows.Forms.Button();
            this.lblSpecimenNumber = new System.Windows.Forms.Label();
            this.dtpCollectionDate = new System.Windows.Forms.DateTimePicker();
            this.dtpExpirationDate = new System.Windows.Forms.DateTimePicker();
            this.txtPhlebotomist = new System.Windows.Forms.TextBox();
            this.lblCollectionDate = new System.Windows.Forms.Label();
            this.lblPhlebotomist = new System.Windows.Forms.Label();
            this.lblExpirationDate = new System.Windows.Forms.Label();
            this.rdoUnacceptable = new System.Windows.Forms.RadioButton();
            this.grpComments = new System.Windows.Forms.GroupBox();
            this.txtDetails = new System.Windows.Forms.TextBox();
            this.lblDetails = new System.Windows.Forms.Label();
            this.cmbComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblComment = new System.Windows.Forms.Label();
            this.grpAssociatedOrders = new System.Windows.Forms.GroupBox();
            this.lvAssociatedOrders = new System.Windows.Forms.ListView();
            this.colOrder = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colStatus = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colWanted = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.patientDisplayPanel1 = new gov.va.med.vbecs.GUI.controls.PatientDisplayPanel();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.grpSpecimen.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).BeginInit();
            this.grpComments.SuspendLayout();
            this.grpAssociatedOrders.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(680, 30);
            this.vbecsLogo1.TabIndex = 5;
            this.vbecsLogo1.Title = "Maintain Specimen";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 411);
            this.lblRequiredField.TabIndex = 7;
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.EnabledButton = false;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
            this.btnOK.Location = new System.Drawing.Point(520, 396);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 2;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(600, 396);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 3;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 76);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(40, 316);
            this.grpImage.TabIndex = 6;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 8);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(32, 36);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // grpSpecimen
            // 
            this.grpSpecimen.AccessibleDescription = "Patient Specimen";
            this.grpSpecimen.AccessibleName = "Patient Specimen";
            this.grpSpecimen.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpSpecimen.Controls.Add(this.grpSplit);
            this.grpSpecimen.Controls.Add(this.rdoAcceptable);
            this.grpSpecimen.Controls.Add(this.cmbProcessingTech);
            this.grpSpecimen.Controls.Add(this.lblProcessingTech);
            this.grpSpecimen.Controls.Add(this.txtSpecimenNumber);
            this.grpSpecimen.Controls.Add(this.pictureBox2);
            this.grpSpecimen.Controls.Add(this.dtpReceivedDate);
            this.grpSpecimen.Controls.Add(this.lblReceivedDate);
            this.grpSpecimen.Controls.Add(this.btnSelectSpecimen);
            this.grpSpecimen.Controls.Add(this.lblSpecimenNumber);
            this.grpSpecimen.Controls.Add(this.dtpCollectionDate);
            this.grpSpecimen.Controls.Add(this.dtpExpirationDate);
            this.grpSpecimen.Controls.Add(this.txtPhlebotomist);
            this.grpSpecimen.Controls.Add(this.lblCollectionDate);
            this.grpSpecimen.Controls.Add(this.lblPhlebotomist);
            this.grpSpecimen.Controls.Add(this.lblExpirationDate);
            this.grpSpecimen.Controls.Add(this.rdoUnacceptable);
            this.grpSpecimen.Controls.Add(this.grpComments);
            this.grpSpecimen.Location = new System.Drawing.Point(48, 76);
            this.grpSpecimen.Name = "grpSpecimen";
            this.grpSpecimen.Size = new System.Drawing.Size(320, 316);
            this.grpSpecimen.TabIndex = 0;
            this.grpSpecimen.TabStop = false;
            this.grpSpecimen.Text = "Patient Specimen";
            this.grpSpecimen.MouseHover += new System.EventHandler(this.CheckValid);
            // 
            // grpSplit
            // 
            this.grpSplit.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpSplit.Location = new System.Drawing.Point(16, 160);
            this.grpSplit.Name = "grpSplit";
            this.grpSplit.Size = new System.Drawing.Size(296, 7);
            this.grpSplit.TabIndex = 13;
            this.grpSplit.TabStop = false;
            // 
            // rdoAcceptable
            // 
            this.rdoAcceptable.AccessibleDescription = "Acceptable Specimen";
            this.rdoAcceptable.AccessibleName = "Acceptable Specimen";
            this.rdoAcceptable.Enabled = false;
            this.rdoAcceptable.Location = new System.Drawing.Point(24, 172);
            this.rdoAcceptable.Name = "rdoAcceptable";
            this.rdoAcceptable.Size = new System.Drawing.Size(148, 20);
            this.rdoAcceptable.TabIndex = 14;
            this.rdoAcceptable.TabStop = true;
            this.rdoAcceptable.Text = "&Acceptable Specimen";
            this.rdoAcceptable.CheckedChanged += new System.EventHandler(this.rdoAcceptable_CheckChanged);
            // 
            // cmbProcessingTech
            // 
            this.cmbProcessingTech.AccessibleDescription = "Processing Technologist";
            this.cmbProcessingTech.AccessibleName = "Processing Technologist";
            this.cmbProcessingTech.Enabled = false;
            this.cmbProcessingTech.Interval = 500;
            this.cmbProcessingTech.Location = new System.Drawing.Point(120, 136);
            this.cmbProcessingTech.MaxLength = 50;
            this.cmbProcessingTech.Name = "cmbProcessingTech";
            this.cmbProcessingTech.Size = new System.Drawing.Size(180, 22);
            this.cmbProcessingTech.TabIndex = 12;
            this.cmbProcessingTech.SelectedIndexChanged += new System.EventHandler(this.cmbProcessingTech_SelectedIndexChanged);
            this.cmbProcessingTech.Leave += new System.EventHandler(this.cmbProcessingTech_SelectedIndexChanged);
            // 
            // lblProcessingTech
            // 
            this.lblProcessingTech.Location = new System.Drawing.Point(24, 136);
            this.lblProcessingTech.Name = "lblProcessingTech";
            this.lblProcessingTech.Size = new System.Drawing.Size(104, 20);
            this.lblProcessingTech.TabIndex = 11;
            this.lblProcessingTech.Text = "Processing Tech*";
            this.lblProcessingTech.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtSpecimenNumber
            // 
            this.txtSpecimenNumber.AccessibleDescription = "Specimen U I D";
            this.txtSpecimenNumber.AccessibleName = "Specimen U I D";
            this.txtSpecimenNumber.Barcode = false;
            this.txtSpecimenNumber.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
            this.txtSpecimenNumber.Location = new System.Drawing.Point(120, 16);
            this.txtSpecimenNumber.MaxLength = 15;
            this.txtSpecimenNumber.Name = "txtSpecimenNumber";
            this.txtSpecimenNumber.Size = new System.Drawing.Size(160, 20);
            this.txtSpecimenNumber.TabIndex = 1;
            this.txtSpecimenNumber.TextChanged += new System.EventHandler(this.txtSpecimenNumber_TextChanged);
            this.txtSpecimenNumber.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.txtSpecimenNumber_KeyPress);
            this.txtSpecimenNumber.Leave += new System.EventHandler(this.txtSpecimenNumber_Leave);
            // 
            // pictureBox2
            // 
            this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
            this.pictureBox2.Location = new System.Drawing.Point(4, 20);
            this.pictureBox2.Name = "pictureBox2";
            this.pictureBox2.Size = new System.Drawing.Size(20, 20);
            this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox2.TabIndex = 112;
            this.pictureBox2.TabStop = false;
            // 
            // dtpReceivedDate
            // 
            this.dtpReceivedDate.AccessibleDescription = "Received Date";
            this.dtpReceivedDate.AccessibleName = "Received Date";
            this.dtpReceivedDate.CustomFormat = "";
            this.dtpReceivedDate.Enabled = false;
            this.dtpReceivedDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpReceivedDate.Location = new System.Drawing.Point(120, 64);
            this.dtpReceivedDate.Name = "dtpReceivedDate";
            this.dtpReceivedDate.Size = new System.Drawing.Size(180, 20);
            this.dtpReceivedDate.TabIndex = 6;
            this.dtpReceivedDate.TextChanged += new System.EventHandler(this.ReceivedDateChanged);
            this.dtpReceivedDate.Leave += new System.EventHandler(this.ReceivedDateChanged);
            // 
            // lblReceivedDate
            // 
            this.lblReceivedDate.Location = new System.Drawing.Point(24, 64);
            this.lblReceivedDate.Name = "lblReceivedDate";
            this.lblReceivedDate.Size = new System.Drawing.Size(108, 20);
            this.lblReceivedDate.TabIndex = 5;
            this.lblReceivedDate.Text = "Received Date*";
            this.lblReceivedDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // btnSelectSpecimen
            // 
            this.btnSelectSpecimen.AccessibleDescription = "find";
            this.btnSelectSpecimen.AccessibleName = "find";
            this.btnSelectSpecimen.Font = new System.Drawing.Font("Arial", 5.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnSelectSpecimen.Location = new System.Drawing.Point(280, 16);
            this.btnSelectSpecimen.Name = "btnSelectSpecimen";
            this.btnSelectSpecimen.Size = new System.Drawing.Size(24, 20);
            this.btnSelectSpecimen.TabIndex = 2;
            this.btnSelectSpecimen.Text = "find";
            this.btnSelectSpecimen.Click += new System.EventHandler(this.btnSelectSpecimen_Click);
            // 
            // lblSpecimenNumber
            // 
            this.errError.SetIconAlignment(this.lblSpecimenNumber, System.Windows.Forms.ErrorIconAlignment.MiddleLeft);
            this.lblSpecimenNumber.Location = new System.Drawing.Point(24, 16);
            this.lblSpecimenNumber.Name = "lblSpecimenNumber";
            this.lblSpecimenNumber.Size = new System.Drawing.Size(84, 20);
            this.lblSpecimenNumber.TabIndex = 0;
            this.lblSpecimenNumber.Text = "Specimen UID*";
            this.lblSpecimenNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // dtpCollectionDate
            // 
            this.dtpCollectionDate.AccessibleDescription = "Collection Date";
            this.dtpCollectionDate.AccessibleName = "Collection Date";
            this.dtpCollectionDate.CustomFormat = "";
            this.dtpCollectionDate.Enabled = false;
            this.dtpCollectionDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpCollectionDate.Location = new System.Drawing.Point(120, 40);
            this.dtpCollectionDate.Name = "dtpCollectionDate";
            this.dtpCollectionDate.Size = new System.Drawing.Size(180, 20);
            this.dtpCollectionDate.TabIndex = 4;
            this.dtpCollectionDate.TextChanged += new System.EventHandler(this.CollectionDateChanged);
            this.dtpCollectionDate.Leave += new System.EventHandler(this.CollectionDateChanged);
            // 
            // dtpExpirationDate
            // 
            this.dtpExpirationDate.AccessibleDescription = "Expiration Date";
            this.dtpExpirationDate.AccessibleName = "Expiration Date";
            this.dtpExpirationDate.CustomFormat = "";
            this.dtpExpirationDate.Enabled = false;
            this.dtpExpirationDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpExpirationDate.Location = new System.Drawing.Point(120, 88);
            this.dtpExpirationDate.Name = "dtpExpirationDate";
            this.dtpExpirationDate.Size = new System.Drawing.Size(180, 20);
            this.dtpExpirationDate.TabIndex = 8;
            this.dtpExpirationDate.TextChanged += new System.EventHandler(this.ExpirationDateChanged);
            this.dtpExpirationDate.Leave += new System.EventHandler(this.ExpirationDateChanged);
            // 
            // txtPhlebotomist
            // 
            this.txtPhlebotomist.AcceptsTab = true;
            this.txtPhlebotomist.AccessibleDescription = "Flabatomist I D";
            this.txtPhlebotomist.AccessibleName = "Flabatomist I D";
            this.txtPhlebotomist.Enabled = false;
            this.txtPhlebotomist.Location = new System.Drawing.Point(120, 112);
            this.txtPhlebotomist.MaxLength = 30;
            this.txtPhlebotomist.Name = "txtPhlebotomist";
            this.txtPhlebotomist.Size = new System.Drawing.Size(180, 20);
            this.txtPhlebotomist.TabIndex = 10;
            this.txtPhlebotomist.TextChanged += new System.EventHandler(this.txtPhlebotomist_TextChanged);
            this.txtPhlebotomist.Leave += new System.EventHandler(this.txtPhlebotomist_TextChanged);
            // 
            // lblCollectionDate
            // 
            this.lblCollectionDate.Location = new System.Drawing.Point(24, 40);
            this.lblCollectionDate.Name = "lblCollectionDate";
            this.lblCollectionDate.Size = new System.Drawing.Size(108, 20);
            this.lblCollectionDate.TabIndex = 3;
            this.lblCollectionDate.Text = "Collection Date*";
            this.lblCollectionDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblPhlebotomist
            // 
            this.lblPhlebotomist.Location = new System.Drawing.Point(24, 112);
            this.lblPhlebotomist.Name = "lblPhlebotomist";
            this.lblPhlebotomist.Size = new System.Drawing.Size(92, 20);
            this.lblPhlebotomist.TabIndex = 9;
            this.lblPhlebotomist.Text = "Phlebotomist ID*";
            this.lblPhlebotomist.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblExpirationDate
            // 
            this.lblExpirationDate.Location = new System.Drawing.Point(24, 88);
            this.lblExpirationDate.Name = "lblExpirationDate";
            this.lblExpirationDate.Size = new System.Drawing.Size(92, 20);
            this.lblExpirationDate.TabIndex = 7;
            this.lblExpirationDate.Text = "Expiration Date*";
            this.lblExpirationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // rdoUnacceptable
            // 
            this.rdoUnacceptable.AccessibleDescription = "Unacceptable Specimen";
            this.rdoUnacceptable.AccessibleName = "Unacceptable Specimen";
            this.rdoUnacceptable.Enabled = false;
            this.rdoUnacceptable.Location = new System.Drawing.Point(24, 192);
            this.rdoUnacceptable.Name = "rdoUnacceptable";
            this.rdoUnacceptable.Size = new System.Drawing.Size(156, 20);
            this.rdoUnacceptable.TabIndex = 15;
            this.rdoUnacceptable.Text = "&Unacceptable Specimen";
            this.rdoUnacceptable.CheckedChanged += new System.EventHandler(this.rdoUnacceptable_CheckedChanged);
            // 
            // grpComments
            // 
            this.grpComments.AccessibleDescription = "Comments";
            this.grpComments.AccessibleName = "Comments";
            this.grpComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpComments.Controls.Add(this.txtDetails);
            this.grpComments.Controls.Add(this.lblDetails);
            this.grpComments.Controls.Add(this.cmbComment);
            this.grpComments.Controls.Add(this.lblComment);
            this.grpComments.Enabled = false;
            this.grpComments.Location = new System.Drawing.Point(16, 196);
            this.grpComments.Name = "grpComments";
            this.grpComments.Size = new System.Drawing.Size(296, 108);
            this.grpComments.TabIndex = 16;
            this.grpComments.TabStop = false;
            // 
            // txtDetails
            // 
            this.txtDetails.AccessibleDescription = "Details";
            this.txtDetails.AccessibleName = "Details";
            this.txtDetails.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtDetails.Location = new System.Drawing.Point(60, 40);
            this.txtDetails.MaxLength = 255;
            this.txtDetails.Multiline = true;
            this.txtDetails.Name = "txtDetails";
            this.txtDetails.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
            this.txtDetails.Size = new System.Drawing.Size(220, 60);
            this.txtDetails.TabIndex = 3;
            this.txtDetails.TextChanged += new System.EventHandler(this.txtDetails_TextChanged);
            this.txtDetails.Leave += new System.EventHandler(this.txtDetails_TextChanged);
            // 
            // lblDetails
            // 
            this.lblDetails.Location = new System.Drawing.Point(8, 40);
            this.lblDetails.Name = "lblDetails";
            this.lblDetails.Size = new System.Drawing.Size(72, 20);
            this.lblDetails.TabIndex = 2;
            this.lblDetails.Text = "Details";
            this.lblDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // cmbComment
            // 
            this.cmbComment.AccessibleDescription = "Comment";
            this.cmbComment.AccessibleName = "Comment";
            this.cmbComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbComment.Interval = 100;
            this.cmbComment.Location = new System.Drawing.Point(60, 16);
            this.cmbComment.MaxLength = 80;
            this.cmbComment.Name = "cmbComment";
            this.cmbComment.Size = new System.Drawing.Size(220, 22);
            this.cmbComment.TabIndex = 1;
            this.cmbComment.SelectedIndexChanged += new System.EventHandler(this.cmbComment_SelectedIndexChanged);
            this.cmbComment.Leave += new System.EventHandler(this.cmbComment_SelectedIndexChanged);
            // 
            // lblComment
            // 
            this.lblComment.Location = new System.Drawing.Point(8, 16);
            this.lblComment.Name = "lblComment";
            this.lblComment.Size = new System.Drawing.Size(76, 20);
            this.lblComment.TabIndex = 0;
            this.lblComment.Text = "Comment*";
            this.lblComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpAssociatedOrders
            // 
            this.grpAssociatedOrders.AccessibleDescription = "Associated Orders";
            this.grpAssociatedOrders.AccessibleName = "Associated Orders";
            this.grpAssociatedOrders.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpAssociatedOrders.Controls.Add(this.lvAssociatedOrders);
            this.grpAssociatedOrders.Location = new System.Drawing.Point(372, 76);
            this.grpAssociatedOrders.Name = "grpAssociatedOrders";
            this.grpAssociatedOrders.Size = new System.Drawing.Size(304, 316);
            this.grpAssociatedOrders.TabIndex = 1;
            this.grpAssociatedOrders.TabStop = false;
            this.grpAssociatedOrders.Text = "Associated Orders";
            // 
            // lvAssociatedOrders
            // 
            this.lvAssociatedOrders.AccessibleDescription = "Associated Orders";
            this.lvAssociatedOrders.AccessibleName = "Associated Orders";
            this.lvAssociatedOrders.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvAssociatedOrders.BackColor = System.Drawing.SystemColors.Control;
            this.lvAssociatedOrders.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.colOrder,
            this.colStatus,
            this.colWanted});
            this.lvAssociatedOrders.FullRowSelect = true;
            this.lvAssociatedOrders.Location = new System.Drawing.Point(8, 16);
            this.lvAssociatedOrders.MultiSelect = false;
            this.lvAssociatedOrders.Name = "lvAssociatedOrders";
            this.lvAssociatedOrders.Size = new System.Drawing.Size(288, 292);
            this.lvAssociatedOrders.TabIndex = 0;
            this.lvAssociatedOrders.UseCompatibleStateImageBehavior = false;
            this.lvAssociatedOrders.View = System.Windows.Forms.View.Details;
            this.lvAssociatedOrders.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvAssociatedOrders_ColumnClick);
            // 
            // colOrder
            // 
            this.colOrder.Text = "Order";
            this.colOrder.Width = 100;
            // 
            // colStatus
            // 
            this.colStatus.Text = "Status";
            // 
            // colWanted
            // 
            this.colWanted.Text = "Date Wanted";
            this.colWanted.Width = 100;
            // 
            // patientDisplayPanel1
            // 
            this.patientDisplayPanel1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientDisplayPanel1.EnabledBloodAvailButton = false;
            this.patientDisplayPanel1.EnabledMedicationButton = false;
            this.patientDisplayPanel1.EnabledRecentOrdersButton = false;
            this.patientDisplayPanel1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientDisplayPanel1.EnabledSIAndTRButton = false;
            this.patientDisplayPanel1.EnabledTransfusionReactionHistoryButton = false;
            this.patientDisplayPanel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientDisplayPanel1.Location = new System.Drawing.Point(4, 32);
            this.patientDisplayPanel1.Name = "patientDisplayPanel1";
            this.patientDisplayPanel1.Patient = null;
            this.patientDisplayPanel1.Size = new System.Drawing.Size(674, 44);
            this.patientDisplayPanel1.TabIndex = 8;
            // 
            // FrmMaintainSpecimen
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(680, 425);
            this.Controls.Add(this.patientDisplayPanel1);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnOK);
            this.Controls.Add(this.grpSpecimen);
            this.Controls.Add(this.grpAssociatedOrders);
            this.HelpButton = true;
            this.hlphelpChm.SetHelpKeyword(this, "Maintain_Specimen.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(464, 452);
            this.Name = "FrmMaintainSpecimen";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Maintain Specimen";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmMaintainSpecimen_KeyDownSpeakMessage);
            this.Load += new System.EventHandler(this.FrmMaintainSpecimen_Load);
            this.Controls.SetChildIndex(this.grpAssociatedOrders, 0);
            this.Controls.SetChildIndex(this.grpSpecimen, 0);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.patientDisplayPanel1, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.grpSpecimen.ResumeLayout(false);
            this.grpSpecimen.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).EndInit();
            this.grpComments.ResumeLayout(false);
            this.grpComments.PerformLayout();
            this.grpAssociatedOrders.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}

		#endregion

		#region Methods

		/// <summary>
		/// Sets some of the default form properties 
		/// </summary>
		private void SetComponentProperties()
		{
            this.LockController.LockFunction = Common.LockFunctions.UC035MaintainSpecimen;

			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC035.FrmMaintainSpecimen());
			//
			//this.patientInfoToolbar1.SingleRowDisplay = false;
			this.LoadCannedComments("SU");
			this.LoadUsers();

			//set custom date and time format
			this.dtpReceivedDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			this.dtpCollectionDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			this.dtpExpirationDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
	
			//set current date value based on the division time zone
			_currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpReceivedDate.Value = _currentDate;
			this.dtpCollectionDate.Value = _currentDate;
			this.dtpExpirationDate.Value = _currentDate.Date.AddDays(3).AddHours(23).AddMinutes(59);	
		}


		/// <summary>
		/// Sets the form controls's enabled state
		/// </summary>
		/// <param name="enable"></param>
		private void SetControlState(bool enable)
		{
			this.dtpCollectionDate.Enabled = enable;
			this.dtpExpirationDate.Enabled = enable;
			this.dtpReceivedDate.Enabled = enable;
			this.rdoUnacceptable.Enabled = enable;
			this.rdoAcceptable.Enabled = enable;
			this.txtPhlebotomist.Enabled = enable;
			this.cmbProcessingTech.Enabled = enable;
		}


		/// <summary>
		/// Event captured from the IsValid and InValid events raised from the _specimen object.
		/// This populates the tooltip of the OK button 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void CheckValid(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = (this._specimen.IsValid && this._specimen.IsDirty);
		}

		/// <summary>
		/// Populates the form controls with data either from the _specimen object or with blanks (defaults)
		/// </summary>
		/// <param name="useObject"></param>
		private void SetControlData(bool useObject)
		{
			//Since alot of our controls use the _Leave/OnChange events, we need to ignore this data "populate"
			this._isLoading = true;

			if (useObject)
			{
				this.GetRequestedProcedures();

				this.txtSpecimenNumber.Text = this._specimen.SpecimenUid;

				if (this._specimen.Patient.PatientGuid == Guid.Empty)
				{
					this.patientDisplayPanel1.Patient = null;
				}

				else
				{
					this.patientDisplayPanel1.Patient = this._specimen.Patient;
				}

				this.txtSpecimenNumber.Text = this._specimen.SpecimenUid;
				this.txtPhlebotomist.Text = this._specimen.Phlebotomist;
				this.dtpCollectionDate.Value = this._specimen.SpecimenCollectionDate;
				this.dtpExpirationDate.Value = this._specimen.SpecimenExpirationDate;
				this.dtpReceivedDate.Value = this._specimen.SpecimenReceivedDate;
				this.rdoUnacceptable.Checked = this._specimen.UnacceptableSpecimenIndicator;
				this.rdoAcceptable.Checked = !this._specimen.UnacceptableSpecimenIndicator;
				this.grpComments.Enabled = this._specimen.UnacceptableSpecimenIndicator;
				if (this._specimen.ProcessingTechId.ToString().Trim().Length>0)
				{
					this.cmbProcessingTech.SelectedIndex = this.cmbProcessingTech.Items.IndexOf(this._specimen.ProcessingTechId);
				}
				else
				{
					this.cmbProcessingTech.SelectedIndex = this.cmbProcessingTech.Items.IndexOf(ThisUser.UserName);
				}
				
				if (this._specimen.UnacceptableSpecimenIndicator && (this._specimen.UnacceptableSpecimenComment != null) && (this._specimen.UnacceptableSpecimenComment.CannedCommentGuid != Guid.Empty))
				{
					this.cmbComment.Text = this._specimen.UnacceptableSpecimenComment.Comments;
					this.txtDetails.Text = this._specimen.UnacceptableSpecimenDetails;
				}
			}
			else
			{
				this.patientDisplayPanel1.Patient = null;
				//set current date value based on the division time zone
				_currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
				this.dtpReceivedDate.Value = _currentDate;
				this.dtpCollectionDate.Value = _currentDate;
				this.dtpExpirationDate.Value = _currentDate.Date.AddDays(3).AddHours(23).AddMinutes(59);	
				this.rdoUnacceptable.Checked = false;
				this.rdoAcceptable.Checked = false;
				this.grpComments.Enabled = false;
				this.cmbComment.SelectedIndex = -1;
				this.txtDetails.Text = String.Empty;
				this.txtPhlebotomist.Text = String.Empty;
				this.cmbProcessingTech.SelectedIndex = -1;
				this.lvAssociatedOrders.Items.Clear();
			}

			//
			if (!((this._specimen.IsAssociatedWithPendingOrder) && (this._specimen.IsNew)))
			{
				this.IsDirty=false;
			}
			this._isLoading = false;
			if (useObject)
			{
				this.CheckDates();
				this.CheckValid(this,EventArgs.Empty);
			}
		}


		/// <summary>
		/// Load the canned comment combobox with the list created based on the supplied categoryCode
		/// </summary>
		/// <param name="categoryCode"></param>
		private void LoadCannedComments(string categoryCode)
		{
			_dtCannedComment = BOL.CannedComment.GetCannedComments(LogonUser.LogonUserDivisionCode, categoryCode);
			
			cmbComment.Items.Clear();
			
			foreach (DataRow dr in _dtCannedComment.Rows)
			{
				this.cmbComment.Items.Add((string)dr[TABLE.CannedCommentText]);
			}
		}

		private void LoadUsers()
		{
			_users = BOL.VbecsUser.GetActiveDivisionUsers( Common.LogonUser.LogonUserDivisionCode );

			cmbProcessingTech.Items.Clear();

			foreach(BOL.VbecsUser user in _users)
			{
				cmbProcessingTech.Items.Add(user.UserName);
			}
		
		}
		/// <summary>
		/// GetRequestedProcedures
		/// </summary>
		private void GetRequestedProcedures()
		{
			try
			{
				DataTable dtRequestedProcedures = BOL.OrderedTest.GetOrderedTestsforSpecimen(this._specimen.SpecimenGuid);
				this.lvAssociatedOrders.Items.Clear();
				//
				foreach (DataRow drTests in dtRequestedProcedures.Rows)
				{
					ListViewItem lvi = new ListViewItem(drTests[Common.DatabaseConstants.ArtificialColumnNames.RequestedProcedure].ToString());
					lvi.SubItems.Add(drTests[Common.VbecsTables.TaskStatus.TaskStatusText].ToString());
					if (drTests.IsNull(Common.VbecsTables.OrderedTest.RequiredResultsDate))
					{
						lvi.SubItems.Add("");
					}
					else
					{
						lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(drTests[Common.VbecsTables.OrderedTest.RequiredResultsDate]));
					}
					this.lvAssociatedOrders.Items.Add(lvi);

				}
				controls.VbecsFunction.SetColumnWidths(lvAssociatedOrders);
				//
				this.errError.SetVbecsError(lvAssociatedOrders, String.Empty); // **** 508 Compliance ***
			}
			catch (Exception ex)
			{
				this.errError.SetVbecsError(lvAssociatedOrders, ex.Message); // **** 508 Compliance ***
			}
		}

		/// <summary>
		/// Gets a specimen object based on the UID and sets the broken rules/events
		/// </summary>
		private bool GetSpecimen(string specimenUid)
		{
			this._specimen = null;
			this._specimen = new BOL.Specimen(specimenUid);
			
			//If the specimen isn't new, then lock it
			if (!this._specimen.IsNew)
			{
				if (!this.SetLocks(this._specimen.SpecimenGuid, this._specimen.UnacceptableSpecimenComment.CannedCommentGuid))
					return(false);
			}

			this._specimen.Valid += new System.EventHandler(this.CheckValid);
			this._specimen.Invalid += new System.EventHandler(this.CheckValid);
			this._specimen.IsDirtyChanged += new System.EventHandler(this.CheckValid);
			//setting the event to fire the setdirtyflag function
			this._specimen.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);

			if (this._specimen.UnacceptableSpecimenComment != null)
			{
				this._specimen.UnacceptableSpecimenComment.IsDirtyChanged += new System.EventHandler(this.CheckValid);
				//setting the event to fire the setdirtyflag function
				this._specimen.UnacceptableSpecimenComment.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);
			}

			if (this._specimen.IsNew)
			{
				if ((this._order ==null) || (this._specimen.IsSpecimenUidComplete == false))	
				{
					//Cannot create a new specimen from Maintain Specimen menu
					this._specimen.SetInitialBrokenRules(this.Name, "ExistingSpecimen");
					this._specimen.SpecimenUid = this._specimen.SpecimenUid;
					this._specimen.Phlebotomist = this._specimen.Phlebotomist;
					string errorMessage = Common.StrRes.SysErrMsg.Common.NoRecordsFoundException("Specimen UID #" + this.txtSpecimenNumber.Text).ResString;
					throw new BOL.NoRecordsFoundException(errorMessage);
				}	
			}
			else
			{
				if (this._order != null)
				{
					this._specimen.IsAssociatedWithPendingOrder = true;
					if (this._order.Patient.PatientGuid != this._specimen.Patient.PatientGuid)
					{
						this.ReleaseLocks(this._specimen.SpecimenGuid, this._specimen.UnacceptableSpecimenComment.CannedCommentGuid);
						throw new Exception(Common.StrRes.SysErrMsg.UC035.SpecimenForDifferentPatient(this._specimen.Patient.DisplayName,this._specimen.Patient.DisplayPatientID,this._order.Patient.DisplayName,this._order.Patient.DisplayPatientID).ResString);

					}
				}
				this._specimen.SetInitialBrokenRules(this.Name, "ExistingSpecimen");
			}

			this._specimen.SpecimenUid = this._specimen.SpecimenUid;
			this._specimen.Phlebotomist = this._specimen.Phlebotomist;
			this._specimen.ProcessingTechId = this._specimen.ProcessingTechId;
			this._specimen.UnacceptableSpecimenIndicator  = this._specimen.UnacceptableSpecimenIndicator;
			
			if (this._specimen.UnacceptableSpecimenIndicator && this._specimen.UnacceptableSpecimenComment != null)
			{
				this._specimen.UnacceptableSpecimenComment.CannedCommentGuid = this._specimen.UnacceptableSpecimenComment.CannedCommentGuid;
				this._specimen.UnacceptableSpecimenComment.IsDirty = false;
			}

			this._specimen.MaintainableSpecimenIndicator = this._specimen.MaintainableSpecimenIndicator;

			return(true);
		}

		#endregion

		#region Events

		/// <summary>
		/// FrmMaintainSpecimen_Load Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmMaintainSpecimen_Load(object sender, System.EventArgs e)
		{
			this.txtSpecimenNumber.Focus();
			//Setting initial state of page to not dirty.
			this.IsDirty=false;
		}

		/// <summary>
		/// cbSpecimenUnacceptable_CheckedChanged Event Handler
		/// Implements BR_35.20
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void rdoUnacceptable_CheckedChanged(object sender, System.EventArgs e)
		{			
			if (!_isLoading)	//Not loading form
			{
				if (this.rdoUnacceptable.Checked)	//Unacceptable specimen radio button checked
				{
					this.grpComments.Enabled = true;
					this.txtDetails.Text = string.Empty;
					this.cmbComment.SelectedIndex = -1;
				}
				//
				try
				{
					this._specimen.UnacceptableSpecimenIndicator = rdoUnacceptable.Checked;
					this.CheckValid(sender,e);
					if (rdoUnacceptable.Checked)
					{
						if (this._specimen.UnacceptableSpecimenComment == null)
						{
							this._specimen.UnacceptableSpecimenComment = new BOL.CannedComment(Guid.NewGuid());
							this._specimen.UnacceptableSpecimenComment.IsNew = true;
						}
						this._specimen.UnacceptableSpecimenComment.CannedCommentGuid = Guid.Empty;
					}
					//
					if (this._order != null)
					{
						//BR_35.20
						this.errError.SetVbecsError(this.rdoAcceptable, String.Empty); // **** 508 Compliance ***
						this.errError.SetVbecsError(this.rdoUnacceptable, Common.StrRes.InfoMsg.UC035.UnacceptableSpecimenNotAllowed().ResString); // **** 508 Compliance ***
					}
					else
					{
						this.errError.SetVbecsError(this.rdoAcceptable, String.Empty); // **** 508 Compliance ***
						this.errError.SetVbecsError(this.rdoUnacceptable, String.Empty); // **** 508 Compliance ***
					}
				}
				catch (BOL.BrokenRuleException err)
				{
					this.errError.SetVbecsError(this.rdoUnacceptable, err.Message); // **** 508 Compliance ***
				}
				this.CheckValid(sender,e);
			}
		}

		/// <summary>
		/// rdoAcceptable_CheckChanged Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void rdoAcceptable_CheckChanged(object sender, System.EventArgs e)
		{
			if (!_isLoading)
			{
				if (this.rdoAcceptable.Checked) // Acceptable specimen radio button checked
				{
					this.grpComments.Enabled = false;
					this.txtDetails.Text = string.Empty;
					this.cmbComment.SelectedIndex = -1;
				}
				//
				try
				{
					this._specimen.UnacceptableSpecimenIndicator = !rdoAcceptable.Checked;
					this.CheckValid(sender,e);
					this.errError.SetVbecsError(this.rdoAcceptable, String.Empty); // **** 508 Compliance ***
					this.errError.SetVbecsError(this.rdoUnacceptable, String.Empty); // **** 508 Compliance ***
				}
				catch (BOL.BrokenRuleException err)
				{
					this.errError.SetVbecsError(this.rdoAcceptable, err.Message); // **** 508 Compliance ***
				}
				this.CheckValid(sender,e);
			}
		}

		/// <summary>
		/// btnOK_Click Event Handler
		/// Implements BR_35.05, 35.10, 35.23
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			BOL.ExceptionReport SpecimenExtendedException = null;
			BOL.ExceptionReport SpecimenReactivatedException = null;
			//
			//BR_35.10
			if (!this._specimen.IsNew)
			{
				if (this._specimen.PreviouslySavedAsUnacceptable || (this._specimen.PreviousExpirationDate < _currentDate))
				{
					if (!this._specimen.UnacceptableSpecimenIndicator && (this._specimen.SpecimenExpirationDate >= _currentDate))
					{
						DlgOverrideComment dlg = new DlgOverrideComment("Reactivate Specimen",Common.StrRes.InfoMsg.UC035.UnexpiredOrUnacceptableSpecimen().ResString,"SG");

						dlg.ShowDialogFromLockedParent(this,false);
						//
						if (dlg.DialogResult != DialogResult.OK)
						{
							return;
						}
						SpecimenReactivatedException = new BOL.ExceptionReport(Common.ExceptionType.Unacceptable_Expired_specimen_used, dlg.Comment, Common.LogonUser.LogonUserName);
						SpecimenReactivatedException.GenerateExceptionSpecimen(this._order, this._specimen);
					}
				}
			}
			//BR_35.05
			if ((this._specimen.IsExtended) && (this._specimen.SpecimenExpirationDate != this._specimen.PreviousExpirationDate))
			{
				string message = "";
				//
				if (this._specimen.HasTransfusionHistory && this._specimen.HasAntibodyIdentification)
				{
					message = string.Concat(Common.StrRes.ConfMsg.UC035.Transfusion().ResString, " and ", Common.StrRes.ConfMsg.UC035.AntibodyFormation().ResString);
				}

				else if (this._specimen.HasTransfusionHistory)
				{
					message = Common.StrRes.ConfMsg.UC035.Transfusion().ResString;
				}

				else if (this._specimen.HasAntibodyIdentification)
				{
					message = Common.StrRes.ConfMsg.UC035.AntibodyFormation().ResString;
				}
				if (message.Length>0)
				{
					message = Common.StrRes.ConfMsg.Common.ExpirationDateExtensionWarning(this._specimen.Patient.DisplayName, this._specimen.Patient.DisplayPatientID,message).ResString;
					//
					DlgOverrideComment dlg = new DlgOverrideComment("Extend Specimen Expiration", message, "SE");

					dlg.ShowDialogFromLockedParent(this,false);
			
					if (dlg.DialogResult != DialogResult.OK) 
					{
						//Return value to previous
						return;
					}

					SpecimenExtendedException = new BOL.ExceptionReport(Common.ExceptionType.Specimen_expiration_date_extended, dlg.Comment, Common.LogonUser.LogonUserName);
					SpecimenExtendedException.GenerateExceptionSpecimen(this._order, this._specimen);
				}
			}
			//
			//BR_35.23
			if (this._specimen.SpecimenExpirationDate < this._currentDate)
			{
				if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC035.ExpiredSpecimen()) != DialogResult.Yes)
				{
					return;
				}
			}
			//
			DialogResult _saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("patient specimen"));
			if (_saveResult == DialogResult.Yes)
			{
				try
				{
					if (this._specimen.IsNew)
					{
						this._specimen.MaintainableSpecimenIndicator = true;
						//
						this._specimen.InsertSpecimen(SpecimenExtendedException, Common.UpdateFunction.UC035FrmMaintainSpecimen);
					}
					else
					{
						this._specimen.UpdateSpecimen(SpecimenReactivatedException, SpecimenExtendedException, Common.UpdateFunction.UC035FrmMaintainSpecimen);
					}
					//CR 1441
					System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.MaintainSpecimen);
					if(dt!= null)
					{
						if(dt.Rows.Count == 0)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
						}
					}
				}
				catch (Common.RowVersionException)
				{
					this.btnOK.RowVersionException = true;		//CR2077
					GuiMessenger.ShowMessageBox(this,Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
					return;
				}
			}
			else
			{
				return;
			}
			//Done updating, close the window.
			this.IsDirty=false;
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		/// <summary>
		/// btnCancel_Click Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		/// <summary>
		/// txtDetails_TextChanged Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtDetails_TextChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				try
				{
					this._specimen.UnacceptableSpecimenDetails = txtDetails.Text;
					this.errError.SetVbecsError(this.txtDetails, String.Empty); // **** 508 Compliance ***
				}
				catch(Exception err)
				{
					this.errError.SetVbecsError(this.txtDetails, err.Message); // **** 508 Compliance ***
				}
				this.CheckValid(sender,e);
			}
		}

		/// <summary>
		/// txtPhlebotomist_TextChanged Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtPhlebotomist_TextChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				try
				{
					this._specimen.Phlebotomist = txtPhlebotomist.Text.Trim();
					this.errError.SetVbecsError(this.txtPhlebotomist, String.Empty); // **** 508 Compliance ***
				}
				catch (Exception err)
				{
					this.errError.SetVbecsError(this.txtPhlebotomist, err.Message); // **** 508 Compliance ***
				}
				this.CheckValid(sender,e);
			}
		}

		/// <summary>
		/// btnSelectSpecimen_Click Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSelectSpecimen_Click(object sender, System.EventArgs e)
		{
			DlgSpecimenSearch dlg;
			 
			if (this._order != null)
			{
				if (this.txtSpecimenNumber.Text == string.Empty)
				{
					dlg = new DlgSpecimenSearch(this._order.Patient);
				}
				else
				{
					dlg = new DlgSpecimenSearch(this._order.Patient, this.txtSpecimenNumber.Text);
				}
				//
				
			}
			else
			{
				dlg = new DlgSpecimenSearch();
			}

            dlg.ShowDialogFromLockedParent(this, false);
			if(dlg.DialogResult == DialogResult.OK)
			{
				try
				{
					if (!this.GetSpecimen(dlg.SpecimenUid))
						return;
					//
					if (!this._specimen.MaintainableSpecimenIndicator)
					{
						this.SetControlData(true);
						this.SetControlState(false);
						this.errError.SetVbecsError(this.btnSelectSpecimen, Common.StrRes.SysErrMsg.UC035.NonMaintainableSpecimen().ResString); // **** 508 Compliance ***
						return;
					}
					//
					this.SetControlData(true);
					this.SetControlState(true);
					this.errError.SetVbecsError(btnSelectSpecimen, ""); // **** 508 Compliance ***
				}
				catch (BOL.BrokenRuleException)
				{
					this._specimen = new BOL.Specimen();
					this.SetControlData(false);
					this.SetControlState(false);
					this.errError.SetVbecsError(btnSelectSpecimen, ""); // **** 508 Compliance ***
				}
				catch (Exception err)
				{
					this._specimen = new BOL.Specimen();
					this.SetControlData(false);
					this.SetControlState(false);
					this.errError.SetVbecsError(btnSelectSpecimen, err.Message); // **** 508 Compliance ***
				}
			}
		}

		/// <summary>
		/// txtSpecimenNumber_KeyPress Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtSpecimenNumber_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			if (!this._isLoading)
			{
				//if a space is pressed at start of string, reject the keypress
				if (((int)e.KeyChar == 32)&&(txtSpecimenNumber.Text.Trim().Length==0))
				{
					e.Handled = true;
					return;
				}
			}
		}

		/// <summary>
		/// btnOrderDetails_Click Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOrderDetails_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.EditAndCreateCannedComments))
			{
				DlgOrderDetails dlgOD = new DlgOrderDetails(_order);

                dlgOD.ShowFromLockedParent(this, false);      //This used to be Show(), changed for locking.
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		/// <summary>
		/// cmbComment_SelectedIndexChanged Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				if (this.cmbComment.SelectedIndex > -1)
				{
					try
					{
						DataRow dr = this._dtCannedComment.Rows[this.cmbComment.SelectedIndex];
						this._specimen.UnacceptableSpecimenComment = new BOL.CannedComment(dr);
						this.errError.SetVbecsError(this.cmbComment, String.Empty); // **** 508 Compliance ***
					}
					catch(BOL.BrokenRuleException err)
					{
						this._specimen.UnacceptableSpecimenComment = null;
						this.errError.SetVbecsError(this.cmbComment, err.Message); // **** 508 Compliance ***
					}
				}
				else
				{
					this._specimen.UnacceptableSpecimenComment = null;
					this.errError.SetVbecsError(this.cmbComment, String.Empty); // **** 508 Compliance ***
				}
				this.CheckValid(sender,e);
			}
			//
			if ((this._specimen.UnacceptableSpecimenComment != null) && (this._specimen.UnacceptableSpecimenComment.Comments != null) && (this._specimen.UnacceptableSpecimenComment.Comments.Trim().ToUpper() == "OTHER"))
			{
				this.lblDetails.Text = "Details*";
			}
			else
			{
				this.lblDetails.Text = "Details";
			}
		}

		/// <summary>
		/// txtSpecimenNumber_TextChanged Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtSpecimenNumber_TextChanged(object sender, System.EventArgs e)
		{
			if (!this._specimen.IsAssociatedWithPendingOrder)
			{
				//
				//Scanner may append a W to the end of the UID
				if ((this.txtSpecimenNumber.Barcode)&&(this.txtSpecimenNumber.Text.Length>10))
				{
					this.txtSpecimenNumber.Text = this.txtSpecimenNumber.Text.Trim(new char[] {'W'});
				}
				//
				this._specimen.SpecimenUid = this.txtSpecimenNumber.Text;
				//
				if (this._specimen.IsSpecimenUidComplete)
				{
					try
					{
						if (!this.GetSpecimen(txtSpecimenNumber.Text))
						{
							this.SetControlData(false);
							this.SetControlState(false);
							this.btnOK.EnabledButton = false;
							return;
						}
						//
						if (!this._specimen.MaintainableSpecimenIndicator)
						{
							this.SetControlData(true);
							this.SetControlState(false);
							this.errError.SetVbecsError(this.btnSelectSpecimen, Common.StrRes.SysErrMsg.UC035.NonMaintainableSpecimen().ResString); // **** 508 Compliance ***
							this.btnOK.EnabledButton = false;
							return;
						}
						//
						this.SetControlData(true);
						this.SetControlState(true);
						this.errError.SetVbecsError(this.btnSelectSpecimen, string.Empty); // **** 508 Compliance ***
						this._specimen.IsDirty = false;
					}
					catch (BOL.BrokenRuleException)
					{
						this.SetControlData(false);
						this.SetControlState(false);
						this.errError.SetVbecsError(this.btnSelectSpecimen, string.Empty); // **** 508 Compliance ***
						this.btnOK.EnabledButton = false;
					}
					catch (Exception err)
					{
						this.SetControlData(false);
						this.SetControlState(false);
						this.errError.SetVbecsError(this.btnSelectSpecimen, err.Message); // **** 508 Compliance ***
						this.btnOK.EnabledButton = false;
					}
				}
				else
				{
					this.SetControlData(false);
					this.SetControlState(false);
					this.errError.SetVbecsError(this.btnSelectSpecimen, string.Empty); // **** 508 Compliance ***
					this.btnOK.EnabledButton = false;
				}
			}
		}

		/// <summary>
		/// CollectionDateChanged Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void CollectionDateChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				try
				{
					this._specimen.SpecimenCollectionDate = dtpCollectionDate.Value;
					this.CheckDates();
					this.CheckValid(sender,e);
				}
				catch(Exception err)
				{
					this.errError.SetVbecsError(this.dtpCollectionDate, err.Message); // **** 508 Compliance ***
				}
			}

		}

		/// <summary>
		/// ReceivedDateChanged Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ReceivedDateChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				try
				{
					this._specimen.SpecimenReceivedDate = dtpReceivedDate.Value;
					this.CheckDates();
					this.CheckValid(sender,e);
				}
				catch(Exception err)
				{
					this.errError.SetVbecsError(this.dtpReceivedDate, err.Message); // **** 508 Compliance ***
				}
				
			}
		}

		/// <summary>
		/// ExpirationDateChanged
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ExpirationDateChanged(object sender, System.EventArgs e)
		{ 
			if (!this._isLoading)
			{
				try
				{
					this._specimen.SpecimenExpirationDate = this.dtpExpirationDate.Value;
					this.CheckDates();
					this.CheckValid(sender,e);
				}
				catch(Exception err)
				{
					this.errError.SetVbecsError(this.dtpExpirationDate, err.Message); // **** 508 Compliance ***
				}
			}
		}
	
		#endregion

		private void cmbProcessingTech_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.cmbProcessingTech.SelectedIndex>-1)
			{
				try
				{
					BOL.VbecsUser user = (BOL.VbecsUser)_users[this.cmbProcessingTech.SelectedIndex];
					this._specimen.ProcessingTechId = user.UserName;
					this.errError.SetVbecsError(this.cmbProcessingTech, String.Empty); // **** 508 Compliance ***
				}
				catch(Exception err)
				{
					this.errError.SetVbecsError(this.cmbProcessingTech, err.Message); // **** 508 Compliance ***
				}
			}
			else
			{
				this._specimen.ProcessingTechId = "";
				this.errError.SetVbecsError(this.cmbProcessingTech, String.Empty); // **** 508 Compliance ***
			}
			this.CheckValid(sender,e);
		}

		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			if(this._specimen.IsValid)
			{
				if (!this._specimen.IsDirty)
				{
					this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToSave().ResString);
				}
				else
				{
					this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
				}
			}
			else
			{
				this.btnOK.SetToolTip(this._specimen.GetBrokenRulesMessage(this.Name));
			}
		}

		private void lvAssociatedOrders_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			controls.ColumnClickSorter.ColumnClickHandler(sender,e,lvAssociatedOrders.CheckBoxes,(e.Column == 2) ? controls.ColumnClickSorter.ColumnSortType.DateTime: controls.ColumnClickSorter.ColumnSortType.String);
		}

		private void CheckDates()
		{
			string collectionDateError = "";
			string receivedDateError = "";
			string expirationDateError = "";
			//
			this._specimen.CompareDates(ref collectionDateError, ref receivedDateError, ref expirationDateError);
			//
			this.errError.SetVbecsError(this.dtpCollectionDate, collectionDateError); // **** 508 Compliance ***
			this.errError.SetVbecsError(this.dtpReceivedDate, receivedDateError); // **** 508 Compliance ***
			this.errError.SetVbecsError(this.dtpExpirationDate, expirationDateError); // **** 508 Compliance ***
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmMaintainSpecimen_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnOK.EnabledButton == false)
			{
				this.btnOK_MouseHover(this, EventArgs.Empty);
				textToSpeak = this.btnOK.GetToolTip();
			}
			if(this.patientDisplayPanel1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak, this.patientDisplayPanel1.GetErrorMessagesFor508());
			}

			this.SpeakMessage( textToSpeak );		
		}

		private void txtSpecimenNumber_Leave(object sender, System.EventArgs e)
		{
			this.btnSelectSpecimen.Enabled = (txtSpecimenNumber.Text == string.Empty);
		}


		#region Properties

		/// <summary>
		/// Get Specimen
		/// </summary>
		public BOL.Specimen Specimen
		{
			get
			{
				return this._specimen;
			}
		}

		#endregion
	}
}
